




; c      360 
 list	P=PIC16F628A 
 #include <P16F628A.INC>
 __CONFIG _BODEN_ON &_PWRTE_ON &_DATA_CP_OFF &_WDT_OFF &_LVP_OFF &_CP_OFF &_MCLRE_OFF &_XT_OSC

 errorlevel-302

 #define	bank_0      STATUS,5
 #define	bank_1	    STATUS,5
 #define	_Z	        STATUS,Z
 #define	_C	        STATUS,C
 #define    SDA         PORTA,0     ;   17
 #define    SCL         PORTA,1     ;   18
 #define    SDA_tris    TRISA,0     ; 
 #define    SCL_tris    TRISA,1     ;
 #define    KEY1        PORTA,5     ; 
 #define	RS		    PORTA,3
 #define	E		    PORTA,2
 #define    ACK         Flag,0     ;  
 #define    NACKM       Flag,1     ;
 #define	D4      	PORTB,4
 #define	D5      	PORTB,5
 #define	D6      	PORTB,6
 #define	D7      	PORTB,7
;         
 cblock     0x20

count_key       ;    
Count_bit       ;  
Count_RX        ;    
Count_shift     ;  
Reg_TX  		;   
Reg_RX   		;    slave
Reg_1
Reg_2
Reg_3
Sec_05
Count
Data_EEPR       ;      EEPROM
Colibr_L        ;    
Colibr_H        ;    
Flag   	        ;  
; 0 - Flag ACK:   0 -   1 -  
; 1 - Flag NACKM: 0 -   1 -  
; 2 -      
         
Colibr_hh       ;
Colibr_h        ;
Colibr_m        ;
Colibr_l 
Emkost_H3
Emkost_HH
Emkost_H
Emkost_M
Emkost_L
C_temp_H3
C_temp_HH
C_temp_H
C_temp_M
C_temp_L
C_led_H3
C_led_HH
C_led_H
C_led_M
C_led_L
Ostatok_L 		; 
Ostatok_H
Delitel_L
Delitel_H
Count_sec_L
Count_sec_H
Bus_Voltage_HH      ;    
Bus_Voltage_H
Bus_Voltage_M
Bus_Voltage_L
Power_H
Power_M
Power_L
Current_HHH
Current_HH
Current_H
Current_M
Current_L
I_temp_L
I_temp_M
I_temp_H
I_temp_HH
Write_command
count_2_10
Bin_HH
Bin_H
Bin_M
Bin_L
bcd_HHH
bcd_HH
bcd_H 
bcd_M
bcd_L
  
	endc

;
            org     0                                           
            goto    START          
            org    4                                            
;; 
Interr	;    
;---------------------------------------;
            bcf         PIR1,0			;
			bsf			INTCON,7		;
            movlw       0x0B            ; 500000us : 8 = 62500 
            movwf       TMR1H           ; 65536 - 62500 = 3036 
            movlw       0xDd            ; = BDC
            movwf       TMR1L           ;
            incf        Sec_05,f		;
            btfss       Sec_05,1		;
            goto        Main_start      ;
            clrf        Sec_05			;
            bsf			Flag,2  		;                       
			GOTO		Main_start      ;
    		;	RETURN					;
;---------------------------------------;
;;
START		bcf     INTCON,GIE      ;   
			bsf		bank_1			;  1
			movlw	b'00000000'
			movwf	TRISB			; 
			movlw	b'00000000'
			movwf	TRISA			; 
			MOVLW   b'10000001' 
            MOVWF   OPTION_REG      ; . . p., .   TMR0,
            bsf     PIE1,0          ;     TMR1
        	bcf		bank_0		    ;  0
			movlw	7
			movwf	CMCON			;  
            movlw   b'00110000'     ;  TMR1
            movwf   T1CON           ;  1 :8			

;        22h  7Fh
            movlw   0x22
            movwf   FSR
Load_ad		clrf    INDF
            incf    FSR,f
            movlw   0x65
            subwf   FSR,w
            btfss   _Z
            goto    Load_ad 
            clrf    PORTA
            clrf    PORTB  

;-----------------------------------;
;          . = 127   
			movlw	1
			call	Read_EEPROM   	;     EEPROM  FF   
            movlw   0xFF            ;   ,  pic   
			subwf	Data_EEPR,w     ; 
			btfss	_Z              ;     
			GOTO	Int_     		; PIC      
            movlw   0x00            ;   
            movwf   Data_EEPR       ;      EEPROM
            movlw   1
            call    Load_EEPROM
            movlw   0x7f            ;               
            movwf   Data_EEPR       ;      EEPROM
            movlw   2
            call    Load_EEPROM
;-----------------------------------;
Int_        bsf     INTCON,6        ;    
            bsf     INTCON,7        ;                                 
;-----------------------------------;
;	goto	zzz
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS;
;    LCD  4-  
;  
Init_LCD    call	    mS_25    	    ;  25    
			movlw	    3			    ; 3-       
			movwf	    Reg_3           ; .     , 
			bsf         D4      	    ;  30h  0011 0000.
            bsf         D5
SetLoop     					        ; set - , loop - . 							 
            call        impuls_E        ;   
			call	    mS_5            ;   LCD 3    0x30. 
			decfsz	    Reg_3,f
			goto	    SetLoop		
			bcf         D4			    ;  30h   
			bsf         D5              ; 4-x (2-    )
            call        impuls_E        ;  20h 
            call        uS_200          ; 
			movlw	    28h			    ; 4- , 2 , 57 (b'0010 1000')
			call        send_LCD	    ;  
			movlw	    0Ch			    ;   (B'00001100')
			call        send_LCD	    ;       
;;
;   
;;
U_          movlw       0x80            ;     
			call        send_LCD        ;
            movlw       'U'		     	;  
			call        Load_znak	    ; 
			movlw	    '-'  	        ;  
			call        Load_znak		; Load - , symbol- .

;---------------------------------------;
I_          movlw       0x89            ; 
			call        send_LCD        ;
            movlw       'I'		     	;  
			call        Load_znak	    ; 
			movlw	    '-'  	        ;  
			call        Load_znak		; Load - , symbol- .
;---------------------------------------;
P_          movlw       0xC0            ;     
			call        send_LCD        ;
            movlw       'P'		     	;  
			call        Load_znak	    ; 
			movlw	    '-'  	        ;  
			call        Load_znak		; Load - , symbol- .
;---------------------------------------;
C_          movlw       0xC9            ; 
			call        send_LCD        ;
            movlw       'Q'		     	;  
			call        Load_znak	    ; 
			movlw	    '-'  	        ;  
			call        Load_znak		; Load - , symbol- .
;---------------------------------------;
;;
                GOTO    Init_INA226
;;
;sssssssssssssssssssssssssssssssssssssss;
impuls_E    bsf         E
            nop
            nop
            bcf         E
                RETURN
;;
;;
;    
Load_znak
            bsf         RS			
            call        send_LCD
                RETURN
;;
;                                  
send_LCD
;             
            bcf         D4
            bcf         D5
            bcf         D6
            bcf         D7
            movwf   	Write_command 
            btfsc       Write_command,4
            bsf         D4
            btfsc       Write_command,5
            bsf         D5
            btfsc       Write_command,6
            bsf         D6
            btfsc       Write_command,7
            bsf         D7
;                
            call        impuls_E
            bcf         D4
            bcf         D5
            bcf         D6
            bcf         D7
            btfsc       Write_command,0
            bsf         D4
            btfsc       Write_command,1
            bsf         D5
            btfsc       Write_command,2
            bsf         D6
            btfsc       Write_command,3
            bsf         D7
            call        impuls_E
			bcf		    RS
			call	    uS_200
			    RETURN
;;
uS_200      movlw       .66
			movwf       Reg_1
            decfsz      Reg_1,F
            goto        $-1
            nop
                RETURN	
;    ;
mS_25       movlw       .118        ;
            movwf       Reg_1       ;  25 
            movlw       .33         ;
            movwf       Reg_2       ;
            decfsz      Reg_1,F     ;
            goto        $-1         ;
            nop                     ;
            decfsz      Reg_2,F     ;
            goto        $-3         ;
                RETURN
;;
mS_5        movlw       .125
            movwf       Reg_1
            movlw       .7
            movwf       Reg_2
            decfsz      Reg_1,F
            goto        $-1
            decfsz      Reg_2,F
            goto        $-3
			    RETURN
;fffffffffffffffffffffffffffffffffff;
;;
;HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH;
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS;
Init_INA226   
;-----------------------------------;
;     
;            ;
aaa         movlw	0x80     	    ; 0x80   (0  1 - Gnd)
			movwf	Reg_TX      	; 
			call	Start	        ;  
			call	TX		        ; 
            btfsc   ACK             ;    
            goto    aaa             ; 
;    ;
            movlw   0               ;   Configuration Register 
			movwf	Reg_TX 	        ; 
			call	TX		        ; 
            btfsc   ACK             ;    
            goto    aaa             ;   ,  
;       ;
            movlw   b'00001110'     ;     
			movwf	Reg_TX 	        ;   - 1024
			call	TX		        ; 
            btfsc   ACK             ;    
            goto    aaa             ;   ,  
;       ;
            movlw   b'11010111'     ;     
			movwf	Reg_TX 	        ;     
			call	TX		        ;     332us
            btfsc   ACK             ;    
            goto    aaa             ;   ,  
			call	Stop	        ;
;-----------------------------------;
;;
;    ;
;            ;
k           movlw	0x80    	    ; 0x80   (0  1 - Gnd)
			movwf	Reg_TX      	; 
			call	Start	        ;  
			call	TX		        ;  
            btfsc   ACK             ;    
            goto    k               ; 
;    ;
            movlw   0x05            ;   Calibration Register 
			movwf	Reg_TX 	        ; 
			call	TX		        ;   
            btfsc   ACK             ;    
            goto    k               ;   ,  
;  Rsh = 0,0015 I = 53,33A   0,00162765 /Bit
;  = .2091 = 0x82b         ; 
;       ;
            movlw   1
            call    Read_EEPROM     ;       
			movwf	Reg_TX 	        ;
			call	TX		        ;  
            btfsc   ACK             ;    
            goto    k               ;   ,  
;       ;
            movlw   2
            call    Read_EEPROM     ;       
			movwf	Reg_TX 	        ; 
			call	TX		        ;   
            btfsc   ACK             ;    
            goto    k               ;   ,  
			call	Stop	        ;

;;
;       INA226   HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH;
;;
Main_start	 bsf   T1CON,0			;  TMR1
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS
;          
Knopki      clrf        count_key
            btfsc		KEY1		    ; 
            goto        Read_Data       ; 
            call        mS_25
            btfss		KEY1
            goto        $-2		        ;    
;---------------------------------------;
			bcf     	INTCON,GIE      ;   
			bcf			T1CON,0
            movlw       0x01            ;   
			call        send_LCD        ;  
            call        mS_25           ;   
            movlw       0x80            ;     
			call        send_LCD        ;
            movlw       'C'		     	;  
			call        Load_znak	    ; 
            movlw       'o'		     	;  
			call        Load_znak	    ; 
            movlw       'r'		     	;  
			call        Load_znak	    ; 
            movlw       'r'		     	;  
			call        Load_znak	    ; 
            movlw       'e'		     	;  
			call        Load_znak	    ;
            movlw       'c'		     	;  
			call        Load_znak	    ; 
            movlw       't'		     	;  
			call        Load_znak	    ;  

;---------------------------------------;
;         
;     
;   
            call        mS_25
            btfsc		KEY1		    ;   
            goto        $-2
            ;----------------
            movlw       .254
            movwf       Reg_1
            movlw       .20
            movwf       Reg_2
            movlw       .11
            movwf       Reg_3
            ;------------------
            decfsz      Reg_1,F
            goto        $-1
            btfsc       KEY1            ;  
            GOTO        Plus            ;   -   
            decfsz      Reg_2,F         ; 
            goto        $-5
            decfsz      Reg_3,F
            goto        $-7
;---------------------------------------;
Minus    ;      
            movlw       0x88            ;     
			call        send_LCD        ;          
			movlw	    '-'  	        ; 
			call        Load_znak	    ;
            ;--------------------
            call        mS_25
            btfss		KEY1
            goto        $-2		        ;    
            call        mS_25
            btfsc		KEY1
            goto        $-2		        ;   
;;      
Minus_i     movlw       .10             ; 
            subwf       count_key,w     ; 
            btfsc       _C              ; 
            decf        count_key,f     ; 10
            incf        count_key,f     ;
           ;----------------------------;
            movlw       1               ;    "1" 
            call		Read_EEPROM     ; EEPROM   
            movwf       Colibr_H
            movwf       Bin_M 
    		movlw       2               ;   "2"  
            call		Read_EEPROM     ;    
            movwf       Colibr_L
            movwf       Bin_L 
        	call		Bin_10	        ;
			;---------------------------;
            swapf       bcd_M,w         ;
            andlw       b'00001111'     ;           
            movwf       Colibr_hh       ;
            movfw       bcd_M           ;
            andlw       b'00001111'     ;           
            movwf       Colibr_h        ; 
            swapf       bcd_L,w         ;
            andlw       b'00001111'     ;           
            movwf       Colibr_m        ; 
            movfw       bcd_L           ;
            andlw       b'00001111'     ;
            movwf       Colibr_l        ;
			;---------------------------;
			call		Ind_correct
           ;----------------------------;
            movlw       .10             ;   
            subwf       count_key,w     ;  , 
            btfss       _C              ; 10 ,  
			call		ms_500          ;
			call		mS_25           ;
			btfsc		KEY1            ;
			goto		Out_1           ;

            movfw       Colibr_H        ;    "0"
            btfss       _Z              ;  STATUS,Z  "0",   ,
            goto        $+4             ;   .     "0",
            movfw       Colibr_L        ;     -
            btfsc       _Z              ; T_L  "0"
            goto        $+6             ;    "0"
            decf        Colibr_L,f      ;    "1"
            movlw       .255            ;  ,   255 -    "0"
            subwf       Colibr_L,w      ; 
            btfsc       _Z              ;   "1"
            decf        Colibr_H,f      ;  
			movfw		Colibr_L        ;
			movwf		Data_EEPR       ;
            movlw       2               ;
			call		Load_EEPROM	    ;
			movfw		Colibr_H        ;
			movwf		Data_EEPR       ;
            movlw       1               ;
			call		Load_EEPROM	    ;
    		btfss		KEY1            ;
			goto		Minus_i         ;
           ;----------------------------;
Out_1		call		mS_25           ;
            btfsc       KEY1            ;            
            goto        $-2
		    call		mS_25           ;
            btfss       KEY1            ;            
            goto        $-2
            movlw       0x01            ;   
			call        send_LCD        ;  
            call        mS_25           ;    
            goto    START           ; Knopki ;                
;
Plus         
            movlw       0x88            ;     
			call        send_LCD        ;          
			movlw	    '+'  	        ; 
			call        Load_znak	    ;
			call		ms_500
           ;--------------------
            call        mS_25
            btfsc		KEY1
            goto        $-2		        ;    
;---------------------------------------; 
Plus_i      movlw       .10             ; 
            subwf       count_key,w     ; 
            btfsc       _C              ; 
            decf        count_key,f     ; 10
            incf        count_key,f     ;

            movlw       1               ;    "1" 
            call		Read_EEPROM     ; EEPROM    
            movwf       Colibr_H        ; 
            movwf       Bin_M 
    		movlw       2               ;   "2"  
            call		Read_EEPROM     ;    
            movwf       Colibr_L        ;
            movwf       Bin_L 
			call		Bin_10	        ;
			;---------------------------;
            swapf       bcd_M,w         ;
            andlw       b'00001111'     ;           
            movwf       Colibr_hh       ;
            movfw       bcd_M           ;
            andlw       b'00001111'     ;           
            movwf       Colibr_h        ; 
            swapf       bcd_L,w         ;
            andlw       b'00001111'     ;           
            movwf       Colibr_m        ; 
            movfw       bcd_L           ;
            andlw       b'00001111'     ;
            movwf       Colibr_l        ;
			;---------------------------;
			call		Ind_correct
           ;----------------------------;
            movlw       .10             ;   
            subwf       count_key,w     ;  , 
            btfss       _C              ; 10 ,  
			call		ms_500
			call		mS_25           ;  

			btfsc		KEY1            ;   ,  , 
			goto		Out_2           ;    
            movlw       0x03            ;     
            subwf       Colibr_H,w      ;   .  
            btfss       _Z              ;  
            goto        $+4             ;    ,    
            movlw       0xe7            ; 
            subwf       Colibr_L,w
            btfss       _Z
			incfsz		Colibr_L,f
            goto        $+2
			incfsz		Colibr_H,f
			movfw		Colibr_L
			movwf		Data_EEPR
            movlw       2
			call		Load_EEPROM
        	movfw		Colibr_H
			movwf		Data_EEPR
            movlw       1
			call		Load_EEPROM
Out_2   	btfss		KEY1            ;
			goto		Plus_i          ;
           ;----------------------------;
			call		mS_25           ;
            btfsc       KEY1            ;            
            goto        $-2
		    call		mS_25           ;
            btfss       KEY1            ;            
            goto        $-2
            movlw       0x01            ;   
			call        send_LCD        ;  
            call        mS_25           ;    
            goto	START               ; Knopki;             
;FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF;
;;
;		  
;;
;-----------------------------------;
Read_Data
;sssssssssssssssssssssssssssssssssss;
;            ;
;        -----;
u           movlw	0x80    	    ;    0x80
			movwf	Reg_TX      	;    (R/W = 0)
			call	Start	        ;   .
			call	TX		        ;   
            btfsc   ACK             ;    
            goto    u               ; 
;      ;
            movlw	2       	    ;    0x02
			movwf	Reg_TX      	;    
			call	TX		        ;   
            btfsc   ACK             ;    
            goto    u               ;   ,  
;                    ;
			call	Start	        ;   .
;          ;
uu          movlw	0x80    	    ;    0x80
			movwf	Reg_TX      	;    
            bsf     Reg_TX,0        ; (R/W = 1)
			call	Start	        ;   .
			call	TX		        ;   
            btfsc   ACK             ;    
            goto    uu              ; 
;-----------------------------------;
            bcf     NACKM  	
            call    RX              ;    
            movfw   Reg_RX          ;    
            movwf   Bus_Voltage_M   ;     
            bsf     NACKM
            call    RX
            movfw   Reg_RX          ;   
            movwf   Bus_Voltage_L   ;     
			call	Stop	        ;   
;;
            movlw   .3              ;     8
            movwf   Count           ;   0,01  
met_U       bcf     _C              ;       
            rrf     Bus_Voltage_M,f ;
            rrf     Bus_Voltage_L,f ;
            decfsz  Count,f         ;
            goto    met_U           ;      
;---------------------------------------;
;fffffffffffffffffffffffffffffffffff;
;sssssssssssssssssssssssssssssssssss;
;          ;
;        -----;
p           movlw	0x80    	    ;    0x80
			movwf	Reg_TX      	;    (R/W = 0)
			call	Start	        ;   .
			call	TX		        ;   
            btfsc   ACK             ;    
            goto    p               ; 
;      ;
            movlw	3       	    ;    0x01
			movwf	Reg_TX      	;    
			call	TX		        ;   
            btfsc   ACK             ;    
            goto    p               ;   ,  
;                    ;
			call	Start	        ;   .
;          ;
pa          movlw	0x80     	    ;    0x80
			movwf	Reg_TX      	;    
            bsf     Reg_TX,0        ; (R/W = 1)
			call	Start	        ;   .
			call	TX		        ;   
            btfsc   ACK             ;    
            goto    pa              ; 
;-----------------------------------;
            bcf     NACKM  	
            call    RX              ;    
            movfw   Reg_RX          ;    
            movwf   Power_M         ;      
            bsf     NACKM
            call    RX
            movfw   Reg_RX          ;   
            movwf   Power_L         ;     
			call	Stop	        ;   
;-----------------------------------;
            movlw       .2          ; 
            movwf       Count       ; 
met_pa      bcf         _C          ;
            rrf         Power_H,f   ;       
            rrf         Power_M,f   ;
            rrf         Power_L,f   ;
            decfsz      Count,f     ;
            goto        met_pa      ;    
;sssssssssssssssssssssssssssssssssss;
;              ;
;        -----;
i           movlw	0x80     	    ;    0x80
			movwf	Reg_TX      	;    (R/W = 0)
			call	Start	        ;   .
			call	TX		        ;   
            btfsc   ACK             ;    
            goto    i               ; 
;      ;
            movlw	4       	    ;    0x01
			movwf	Reg_TX      	;    
			call	TX		        ;   
            btfsc   ACK             ;    
            goto    i               ;   ,  
;                     ;
			call	Start	        ;   .
;          ;
ii          movlw	0x80    	    ;    0x80
			movwf	Reg_TX      	;    
            bsf     Reg_TX,0        ; (R/W = 1)
			call	Start	        ;   .
			call	TX		        ;   
            btfsc   ACK             ;    
            goto    ii              ; 
;-----------------------------------;
            bcf     NACKM  	
            call    RX              ;    
            movfw   Reg_RX          ;    
            movwf   Current_M       ;      
            bsf     NACKM
            call    RX
            movfw   Reg_RX          ;   
            movwf   Current_L       ;     
			call	Stop	        ;   
;-----------------------------------;
            btfss   Current_M,7     ;    
            goto    Proverka
            clrf    Current_L
            clrf    Current_M
;;
;			goto	Preobr_U    
;;
;;
;		  
;CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC;
;;
;  ,   ,     ,
;..       .
;-------------------------------------------------;
Proverka	btfss	Flag,2		;    
			goto	Preobr_U				
;   360    , 360  0,1 
;  12500= 12,5     = 12,50 = 1250
; 3601250=450000,    ,   3600 .  
;   \.       4500000  3600
;   16 (4  )    3600/16=225.
;------------------------------------------; 
;     
;------------------------------------------;
				
Emkoct	   	bcf		Flag,2			;  	
            movfw   Current_M
			movwf	I_temp_M
            movfw   Current_L
			movwf	I_temp_L	
;-----------------------------------;
Slojenie    movfw   I_temp_L
            addwf   C_temp_L,f
            movfw   I_temp_M
            btfsc   _C
            incfsz  I_temp_M,w
            addwf   C_temp_M,f
            movfw   I_temp_H
            btfsc   _C
            incfsz  I_temp_H,w
            addwf   C_temp_H,f
            movfw   I_temp_HH
            btfsc   _C
            incfsz  I_temp_HH,w
            addwf   C_temp_HH,f
;;
;      360 0x168	;
 			incfsz	Count_sec_L,f
			goto	$+2
			incfsz	Count_sec_H,f
			movfw	Count_sec_L
			sublw	0x68
			btfss	_Z
			goto	Preobr_U		;    360 	
			btfss	Count_sec_H,0	; ,      
			goto	Preobr_U		;
			clrf	Count_sec_L
			clrf	Count_sec_H
;;
;-----------------------------------;
;			  16
;-------------------------------;
Shift_C     movlw   .4          ;      16
            movwf   Count       ; 
met_C       bcf     _C          ;       
            rrf     C_temp_HH,f ;
            rrf     C_temp_H,f  ;
            rrf     C_temp_M,f  ;
            rrf     C_temp_L,f  ;
            decfsz  Count,f     ;
            goto    met_C       ;
;-------------------------------;
;    225,   Emkost_L  Emkost_M
;-------------------------------;
			movlw	.225
			movwf	Delitel_L
			clrf	Delitel_H
Delenie		movlw 	.32 			; 32-bit  16-bit
			movwf	Count
			clrf	Ostatok_H 		; 
			clrf	Ostatok_L
dvloop      bcf		_C 		    	; 
;      
			rlf		C_temp_L,f 		; 
			rlf		C_temp_M,f
			rlf		C_temp_H,f
			rlf		C_temp_HH,f		; 
			rlf 	Ostatok_L,f 	; 
			rlf		Ostatok_H,f

			btfsc	_C 				;   
			goto 	subd
			movfw 	Delitel_H 		;     
			subwf 	Ostatok_H,w
			btfss	_Z 
			goto 	testgt 			;  ,  ,   Ostatok_H
			movfw 	Delitel_L 		;   ,   
			subwf 	Ostatok_L,w
testgt 		btfss	_C 				;  ,  Ostatok_> = Delitel_
			goto 	remrlt

subd 		movfw   Delitel_L 		;     
			subwf 	Ostatok_L,f
			btfss	_C 				;   

			decf 	Ostatok_H,f 	;  
			movfw 	Delitel_H
			subwf 	Ostatok_H,f
			bsf 	C_temp_L,0 	;     1
; Quotient replaces dividend which is lost    
remrlt 		decfsz 	Count,f
			goto 	dvloop
;-----------------------------------;
;        0.1  
;-----------------------------------;
Slojen      movfw   C_temp_L
            addwf   Emkost_L,f

            movfw   C_temp_M
            btfsc   _C
            incfsz  C_temp_M,w
            addwf   Emkost_M,f

            movfw   C_temp_H
            btfsc   _C
            incfsz  C_temp_H,w
            addwf   Emkost_H,f

            movfw   C_temp_HH
            btfsc   _C
            incfsz  C_temp_HH,w
            addwf   Emkost_HH,f
			;-----------------------;
			clrf	C_temp_L 		; 
			clrf	C_temp_M
			clrf	C_temp_H
			clrf	C_temp_HH
			clrf	C_temp_H3
			;-----------------------;
Fin 		GOTO    Preobr_Emkost
;;
;FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF;
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS;
;-----------------------------------;
;          I2C       ;
; 1    ;							
TX			bcf   	ACK             ;  
			movlw 	.8              ;  
			movwf 	Count_bit       ;    
Loop_tx                             ;
            btfsc 	Reg_TX,7        ;    
			call  	Data_1          ; .  "1" -   
			btfss 	Reg_TX,7        ; 
			call  	Data_0          ;   
			call  	Clock_1         ;   (  )
			btfss 	SCL             ; ,      
			goto  	$-1             ;    
            goto    $+1             ;  2 
            goto    $+1             ;  2 
			call  	Clock_0         ;   .   
			rlf   	Reg_TX,f        ;     
			decfsz 	Count_bit,f     ;    1
			goto  	Loop_tx         ;    
			call  	Data_1			;   .  , 
			call  	Clock_1			;  slave    
                                    ;
			btfss 	SCL             ; ,      
			goto  	$-1             ;     
			btfsc 	SDA             ;   
			bsf   	ACK             ;  ,   !!! 
			call  	Clock_0         ;   
				return              ;
;fffffffffffffffffffffffffffffffffff;
;sssssssssssssssssssssssssssssssssss;
;     -
RX     		clrf  	Reg_RX  		;  8    slave-,  
			movlw 	.8				;         
			movwf 	Count_bit		;       
Loop_read							;  .     .
			bcf   	_C      		;   
			rlf   	Reg_RX,f        ;    
			call  	Data_1          ;   
            goto    $+1             ;
            goto    $+1             ;
			call  	Clock_1         ;                          
			btfss 	SCL             ;     Slave   
			goto  	$-1             ;      
			btfsc 	SDA             ;  ,   
			bsf   	Reg_RX,0        ;   ,  .
			call  	Clock_0         ;    -      
			decfsz 	Count_bit,f     ; ,      
			goto  	Loop_read       ; ,      

			btfss 	NACKM           ;  .     , 
			call  	Data_0          ; , NACKM   0 -  
			btfsc 	NACKM           ; -     
			call  	Data_1          ;   ,     
                                    ;  1,     .
			call  	Clock_1         ;    
    	    btfss 	SCL             ;      Slave. 
			goto  	$-1             ;  ,      
            nop                     ;
			call  	Clock_0         ;    
				return 
;-----------------------------------;
Start	    Call  	Clock_1			;   (Clock_1)    ,(  )
									;     -   -.
			call    Data_1		    ;   ,     (  )
			goto  	$+1             ; 
            goto    $+1             ; 
            goto    $+1             ; 
			Call  	Data_0		    ;   -  (  )
			goto  	$+1             ;   
            goto    $+1             ; (   )
            goto    $+1             ;     Data
			Call  	Clock_0 		;   .	
				return				; 
;
Clock_0     bsf  	bank_1          ;      - 
			bcf  	SCL_tris			;   
		    bcf  	bank_0	        ;   ""     0.          
    		bcf  	SCL
			goto  	$+1             ; 
            goto    $+1             ; 
            goto    $+1             ;
				return
;
Clock_1  	bsf  	bank_1			;     Z- - 
			bsf  	SCL_tris	        ;     .
			bcf  	bank_0
			goto  	$+1             ; 
            goto    $+1             ; 
            goto    $+1             ;
				return
;
Stop        						;   -    
			call  	Data_0			;   Clock   
			call  	Clock_1			; Data    .      
             						;    (  Clock 
			goto  	$+1             ; 
            goto    $+1             ; 
            goto    $+1             ;
			btfss 	SCL	            ; )     Data
			goto  	$-1         	; (     
			call  	Data_1			;   ).
				return				; 
;
Data_0		bsf  	bank_1			;      - 
			bcf  	SDA_tris	        ;     ""
			bcf  	bank_0		    ;     0. 
			bcf		SDA	            ;
			goto  	$+1             ; 
            goto    $+1             ; 
            goto    $+1             ;
				return
;
Data_1		bsf  	bank_1			;    Z- - 
			bsf  	SDA_tris	        ;    . 
			bcf  	bank_0			;
			goto  	$+1             ; 
            goto    $+1             ; 
            goto    $+1             ;
				return				;
;FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF;   
;          2_10
;;
;---------------------------------------;    			
Preobr_Emkost
            movfw       Emkost_HH		; 
            movwf       Bin_HH 
            movfw       Emkost_H        ; 
            movwf       Bin_H       
            movfw       Emkost_M        ; 
            movwf       Bin_M 
            movfw       Emkost_L        ; 
            movwf       Bin_L 
            call        Bin_10	        ; 
 
            movfw       bcd_H           ;
            andlw       b'00001111'     ;
            movwf       C_led_H3       ; 
            swapf       bcd_M,w         ;
            andlw       b'00001111'     ;           
            movwf       C_led_HH       ;
            movfw       bcd_M           ;
            andlw       b'00001111'     ;           
            movwf       C_led_H        ; 
            swapf       bcd_L,w         ;
            andlw       b'00001111'     ;           
            movwf       C_led_M        ; 
            movfw       bcd_L           ;
            andlw       b'00001111'     ;
            movwf       C_led_L        ; 
;---------------------------------------;               
Preobr_U      
            movfw       Bus_Voltage_M   ; 
            movwf       Bin_M 
            movfw       Bus_Voltage_L   ; 
            movwf       Bin_L 
            call        Bin_10

            swapf       bcd_M,w         ;
            andlw       b'00001111'     ;           
            movwf       Bus_Voltage_HH  ;
            movfw       bcd_M           ;
            andlw       b'00001111'     ;           
            movwf       Bus_Voltage_H   ; 
            swapf       bcd_L,w         ;
            andlw       b'00001111'     ;           
            movwf       Bus_Voltage_M   ; 
            movfw       bcd_L           ;
            andlw       b'00001111'     ;
            movwf       Bus_Voltage_L   ; 	
;---------------------------------------;                        
Preobr_P   
            movfw       Power_H
            movwf       Bin_H
            movfw       Power_M
            movwf       Bin_M
            movfw       Power_L
            movwf       Bin_L
            call        Bin_10	        ;

            movfw       bcd_M           ;
            andlw       b'00001111'     ;           
            movwf       Power_H         ; 
            swapf       bcd_L,w         ;
            andlw       b'00001111'     ;           
            movwf       Power_M         ; 
            movfw       bcd_L           ;
            andlw       b'00001111'     ;
            movwf       Power_L         ; 
Preobr_I
            movfw       Current_M       ;
            movwf       Bin_M
            movfw       Current_L       ;
            movwf       Bin_L
            call        Bin_10	        ;

            movfw       bcd_H           ;
            andlw       b'00001111'     ;           
            movwf       Current_HHH     ;                                ;
            swapf       bcd_M,w         ;
            andlw       b'00001111'     ;           
            movwf       Current_HH      ;
            movfw       bcd_M           ;
            andlw       b'00001111'     ;           
            movwf       Current_H       ; 
            swapf       bcd_L,w         ;
            andlw       b'00001111'     ;           
            movwf       Current_M       ; 
            movfw       bcd_L           ;
            andlw       b'00001111'     ;
            movwf       Current_L       ; 
			goto		Pokaz_U
;;
;  :     Bin_HH,Bin_H,Bin_M,Bin_L.  Bin_H -  .
; :       bcd_L,     bcd_L,
;      bcd_M,    bcd_M  ..
;--------------------------------------------------------------------------------------------------;
Bin_10
            movlw       .32 
			movwf       count_2_10
			clrf		bcd_HH
			clrf		bcd_H 
			clrf        bcd_M 
			clrf        bcd_L 
			goto        start 
adjdec      movlw       0x33
			addwf       bcd_HHH,f 
			addwf       bcd_HH,f  
			addwf       bcd_H,f 
			addwf       bcd_M,f 
			addwf       bcd_L,f 
			movlw       0x03 
			btfss       bcd_HHH,3 
			subwf       bcd_HHH,f 
			btfss       bcd_HH,3 
			subwf       bcd_HH,f 
			btfss       bcd_H,3 
			subwf       bcd_H,f 
			btfss       bcd_M,3 
			subwf       bcd_M,f 
			btfss       bcd_L,3 
			subwf       bcd_L,f 
			movlw       0x30 
			btfss       bcd_HHH,7 
			subwf       bcd_HHH,f 
			btfss       bcd_HH,7 
			subwf       bcd_HH,f 
			btfss       bcd_H,7 
			subwf       bcd_H,f 
			btfss       bcd_M,7 
			subwf       bcd_M,f 
			btfss       bcd_L,7 
			subwf       bcd_L,f 
start       
			rlf         Bin_L,f 
			rlf         Bin_M,f
			rlf         Bin_H,f 
			rlf         Bin_HH,f 
			rlf         bcd_L,f 
			rlf         bcd_M,f 
			rlf         bcd_H,f 
			rlf         bcd_HH,f 
			rlf         bcd_HHH,f 
			decfsz      count_2_10,f 
			goto        adjdec 
            clrf        Bin_L 
			clrf        Bin_M 
            clrf        Bin_H 
			clrf        Bin_HH
				RETURN 
;---------------------------------------;
;HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH;
;
;                     
;
;     
Pokaz_U     movlw       0x82    	        ;     
			call        send_LCD            ;  

            movfw       Bus_Voltage_HH
            btfss       _Z
            goto        $+4                 ;    
            movlw       20h			        ;   (  )
			call        Load_znak       	;
            goto        U
            movlw       30h			        ;        
            addwf       Bus_Voltage_HH,w    ; ,   ,   
			call        Load_znak	        ;     ,  
                                            ;        

U           movlw       30h			        ;        
            addwf       Bus_Voltage_H,w  	; . 30h = 0011 0000
			call        Load_znak	        ;    

            movlw       ','
			call        Load_znak	        ; 

            movlw       30h			        ; 
            addwf       Bus_Voltage_M,w  	; 
			call        Load_znak           ;
 
            movlw       30h			        ; 
            addwf       Bus_Voltage_L,w  	; 
			call        Load_znak	        ;

            movlw       'B'
			call        Load_znak	        ; 
;fffffffffffffffffffffffffffffffffffffffffff;
;-------------------------------------------;
;     

Pokaz_P     movlw       0xC2    	        ;     
			call        send_LCD            ;  

            movfw       Power_H
            btfsc       _Z
            goto        Pa
            movlw       30h			        ; 
            addwf       Power_H,w           ; 
			call        Load_znak	        ;
			goto		Pb 
                                            ; 
Pa          movfw       Power_M
            btfsc       _Z
            goto        Pc
Pb          movlw       30h			        ; 
            addwf       Power_M,w  	        ; 
			call        Load_znak           ;

Pc          movlw       30h			        ; 
            addwf       Power_L,w  	        ; 
			call        Load_znak           ;

            movlw       'V'
			call        Load_znak	        ; 
            movlw       'A'			        ;     
			call        Load_znak	        ;   ''

            movlw       20h			        ;   (  )
			call        Load_znak       	;

            movlw       20h			        ;   (  )
			call        Load_znak       	;

;fffffffffffffffffffffffffffffffffffffffffff;
;-------------------------------------------;
;     

Pokaz_I     movlw       0x8b   	            ;     
			call        send_LCD            ;  

            movfw       Current_HH
            btfss       _Z
            goto        $+4                 ;    
            movlw       20h			        ;   (  )
			call        Load_znak       	;
            goto        Ia
            movlw       30h			        ; 
            addwf       Current_HH,w        ; 
			call        Load_znak	        ; 

 
Ia          movlw       30h			        ;        
            addwf       Current_H,w     	; . 30h = 0011 0000
			call        Load_znak	        ;    

            movlw       ','
			call        Load_znak	        ;

            movlw       30h			        ; 
            addwf       Current_M,w  	    ; 
			call        Load_znak           ;

     		movlw       0x8f   	            ;     
			call        send_LCD            ;  
            movlw       'A'					;     - 
			call        Load_znak	        ;   
;-------------------------------------------;
;     

Pokaz_C     movlw       0xCb    	        ;     
			call        send_LCD            ;  

            movfw       C_led_H3
            btfsc       _Z
            goto        Ca
            movlw       30h			        ; 
            addwf       C_led_H3,w         ; 
			call        Load_znak	        ;
			goto		Cb 
                                            ; 
Ca          movfw       C_led_HH
            btfsc       _Z
            goto        Cc
Cb          movlw       30h			        ; 
            addwf       C_led_HH,w  	    ; 
			call        Load_znak           ;


Cc          movlw       30h			        ; 
            addwf       C_led_H,w  	    ; 
			call        Load_znak           ;

            movlw       ','
			call        Load_znak	        ;

            movlw       30h			        ; 
            addwf       C_led_M,w  	    ; 
			call        Load_znak           ;

            movlw       30h			        ; 
            addwf       C_led_L,w  	    ; 
			call        Load_znak           ;

            movlw       20h			        ;   (  )
			call        Load_znak       	;

            movlw       20h			        ;   (  )
			call        Load_znak       	;
     
;;
            clrf        Bus_Voltage_HH      ;    
            clrf        Bus_Voltage_H
            clrf        Bus_Voltage_M
            clrf        Bus_Voltage_L
            clrf        Power_H
            clrf        Power_M
            clrf        Power_L
            clrf        Current_HHH
            clrf        Current_HH
            clrf        Current_H
            clrf        Current_M
            clrf        Current_L

			goto		$
   
;;

;    ;
ms_500      movlw       .85
            movwf       Reg_1
            movlw       .138
            movwf       Reg_2
            movlw       .3
            movwf       Reg_3
            decfsz      Reg_1,F
            goto        $-1
            decfsz      Reg_2,F
            goto        $-3
            decfsz      Reg_3,F
            goto        $-5
                RETURN
;
;--------------------------------------------------------------------------------;
;IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII;
Ind_correct movlw       0x8a   	        ;     
			call        send_LCD        ;  
 
            movlw       30h			    ;        
            addwf       Colibr_hh,w     ; . 30h = 0011 0000
			call        Load_znak	    ;    

            movlw       30h			    ;        
            addwf       Colibr_h,w      ; . 30h = 0011 0000
			call        Load_znak	    ;    

            movlw       30h			    ;        
            addwf       Colibr_m,w      ; . 30h = 0011 0000
			call        Load_znak	    ;    

            movlw       30h			    ;        
            addwf       Colibr_l,w      ; . 30h = 0011 0000
			call        Load_znak	    ;    
                RETURN
;
;      EEPROM 
;----------------------------------;
Load_EEPROM
			bcf			INTCON,GIE  	;   .
 			bsf		    bank_1
            movwf       EEADR       	;   .
 			bcf		    bank_0
            movfw       Data_EEPR   	;     Registr   W.
			bsf			bank_1
            movwf       EEDATA      	;     W   EEPROM   02h.
            bsf         EECON1,2    	;  . 
                                  
            movlw       055h        	; 
            movwf       EECON2      	; 
            movlw       0AAh        	;  .
            movwf       EECON2      	; ----"----
            bsf         EECON1,1        ; ----"---
				   		
L20			btfsc		EECON1, WR		;   
			goto		L20
			bcf			EECON1, WREN	;    EEROM
			bcf     	bank_0			;    0
;			bsf         INTCON,GIE  	;   .
				RETURN
;===============================;
;       EEPROM
;===============================;
;-------------------------------;
;-------------------------------;
Read_EEPROM	
			bsf     bank_1      ;   1 .           
            movwf   EEADR       ;  02h   W   EEAdr.
            bsf     EECON1,0    ;  ( )			
            movfw   EEDATA      ; .    EEPROM   02h   W.
			bcf		bank_0			
            movwf   Data_EEPR   ;     W   Registr.            			
			    RETURN
;-------------------------------;
;FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF;

        END

